/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome;

import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import website.eccentric.tome.Tag;

public class Migration {
    public static final int CURRENT_VERSION = 1;
    public static Map<Integer, Consumer<ItemStack>> steps = Map.of(1, Migration::one);

    public static void apply(ItemStack stack) {
        while (Migration.getVersion(stack) < 1) {
            int version = Migration.getVersion(stack) + 1;
            steps.get(version).accept(stack);
            Migration.setVersion(stack, version);
        }
    }

    public static int getVersion(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return 0;
        }
        if (!tag.m_128441_(Tag.VERSION)) {
            return 0;
        }
        return tag.m_128451_(Tag.VERSION);
    }

    public static void setVersion(ItemStack stack, int version) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(Tag.VERSION, version);
    }

    public static void setVersion(ItemStack stack) {
        Migration.setVersion(stack, 1);
    }

    public static void one(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_(Tag.key("name"));
        tag.m_128473_(Tag.key("mod"));
        String books = Tag.key("books");
        CompoundTag oldMods = tag.m_128469_(books);
        if (oldMods == null) {
            oldMods = new CompoundTag();
        }
        tag.m_128473_(books);
        CompoundTag mods = new CompoundTag();
        for (String modName : oldMods.m_128431_()) {
            CompoundTag modTag = new CompoundTag();
            modTag.m_128365_(Integer.toString(0), oldMods.m_128423_(modName));
            mods.m_128365_(modName, (net.minecraft.nbt.Tag)modTag);
        }
        tag.m_128365_(Tag.MODS, (net.minecraft.nbt.Tag)mods);
    }
}

